---
title: Return small HTML page · Cloudflare Workers docs
description: Deliver an HTML page from an HTML string directly inside the Worker script.
lastUpdated: 2025-08-20T18:47:44.000Z
chatbotDeprioritize: false
tags: JavaScript,TypeScript,Python,Rust
source_url:
  html: https://developers.cloudflare.com/workers/examples/return-html/
  md: https://developers.cloudflare.com/workers/examples/return-html/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/return-html)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwAWQQDYxARgDMg2YMEAuFizbAOcLjT4CR4qbPmCAsACgAwuioQAptewARKAGcY6Z1GhXFJNXgLEJFRwwDYMAERQNDYAHgB0AFbO4aSoUGB2IWGR0fFJ4WaW1nYQ2AAqdDA2PnAwMGB8BFBWyAlwAG5wzrwIsBAA1MDouOA2ZmaxbkgkuDaocOAQJADepiQkXXRUvL42ELwAFgAUCDYAjiA2zhAAlCtr6yS8VtckBxDAYCQMJAAGADwAQgcAHlzGUAJoABQAom8PmAAHwPdb-Ci4OjIx6Pf4HSSIgASNjAYHQJAA6pgwLh-sg8VjsSR-jBEWUDi4SMBEABrEAwEgAdy6JAA5nYbAgCDZcOQ6BsSOZSSBcKgwIgbBTMNyJXFaSyUUzkOjMb8iKYDacICAEFQgjYBSQAEpXNxUZw2I7vT4AGnujLeNjgswQzh8q3963Cz2K9gglRs4R84VsMRQXrAREOiHdEAYAFUygAxbAADnC3oN6wAvhXsVWbmbqxWq0QzCpmGoNFoePwhKIJDI5AoTBYrLZ7E5XO5PM0qD4-BpSMFQhFQoQNClfOlMivwmRSWQCqOY6UKlUanUGrwmi0klZxqZluEuVEAPpDEYZRM5WZ5ZJVtt207AJux0Pt9EHIxmDMIA)

* TypeScript

  ```ts
  export default {
    async fetch(request): Promise<Response> {
      const html = `<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>`;


      return new Response(html, {
        headers: {
          "content-type": "text/html;charset=UTF-8",
        },
      });
    },
  } satisfies ExportedHandler;
  ```

* Python

  ```py
  from workers import WorkerEntrypoint, Response


  class Default(WorkerEntrypoint):
      async def fetch(self, request):
          html = """<!DOCTYPE html>
          <body>
            <h1>Hello World</h1>
            <p>This markup was generated by a Cloudflare Worker.</p>
          </body>"""


          headers = {"content-type": "text/html;charset=UTF-8"}
          return Response(html, headers=headers)
  ```

* Rust

  ```rs
  use worker::*;


  #[event(fetch)]
  async fn fetch(_req: Request, _env: Env, _ctx: Context) -> Result<Response> {
      let html = r#"<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker.</p>
      </body>
      "#;
      Response::from_html(html)
  }
  ```

* Hono

  ```ts
  import { Hono } from "hono";
  import { html } from "hono/html";


  const app = new Hono();


  app.get("*", (c) => {
    const doc = html`<!DOCTYPE html>
      <body>
        <h1>Hello World</h1>
        <p>This markup was generated by a Cloudflare Worker with Hono.</p>
      </body>`;


    return c.html(doc);
  });


  export default app;
  ```
