---
title: Configure a custom rule with the Skip action · Cloudflare Web Application
  Firewall (WAF) docs
description: Use the Skip action in a custom rule to skip one or more security
  features. A rule configured with the Skip action is also known as a skip rule.
lastUpdated: 2025-10-17T11:29:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/skip/
  md: https://developers.cloudflare.com/waf/custom-rules/skip/index.md
---

Use the *Skip* action in a custom rule to skip one or more security features. A rule configured with the *Skip* action is also known as a skip rule.

For more information on the available options, refer to [Available skip options](https://developers.cloudflare.com/waf/custom-rules/skip/options/).

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com), and select your account and domain.

  2. Go to **Security** > **WAF** > **Custom rules**.

  3. [Create a custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) by selecting **Create rule**, or edit an existing custom rule.

  4. Define the rule name and the rule expression.

  5. Under **Choose action**, select *Skip* from the dropdown.

     ![Available Skip action options when configuring a custom rule](https://developers.cloudflare.com/_astro/skip-action-options.N8Emdhwv_ZWPFzD.webp)

  6. Configure the desired [skip options](https://developers.cloudflare.com/waf/custom-rules/skip/options/).

  7. Save your changes.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. [Create a custom rule](https://developers.cloudflare.com/waf/custom-rules/create-dashboard/) by selecting **Create rule** > **Custom rules**, or edit an existing custom rule.

  3. Define the rule name and the rule expression.

  4. Under **Choose action**, select *Skip* from the dropdown.

     ![Available Skip action options when configuring a custom rule](https://developers.cloudflare.com/_astro/skip-action-options.N8Emdhwv_ZWPFzD.webp)

  5. Configure the desired [skip options](https://developers.cloudflare.com/waf/custom-rules/skip/options/).

  6. Save your changes.

* API

  Use the [Rulesets API](https://developers.cloudflare.com/ruleset-engine/rulesets-api/) to configure custom rules via API.

  Refer to [API examples](https://developers.cloudflare.com/waf/custom-rules/skip/api-examples/) for examples of creating skip rules.
