---
title: Introduction · Cloudflare Style Guide
description: Overview of what the content will cover. Used in lengthier
  documents to help users understand whether they should invest time in reading
  the content.
lastUpdated: 2025-02-07T16:05:44.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/introduction/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/introduction/index.md
---

## Definition

Overview of what the content will cover. Used in lengthier documents to help users understand whether they should invest time in reading the content.

## Used in

[Reference architecture](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference-architecture/), [Design guide](https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/design-guide/)

## Structure

No longer than half a page. Usually 1-3 paragraphs. The first paragraph should quickly and clearly explain the topic and the last paragraph explain what the document contains.

## Example

Cloudflare One is a secure access service edge (SASE) platform that protects enterprise applications, users, devices, and networks. By progressively adopting Cloudflare One, organizations can move away from their patchwork of hardware appliances and other point solutions and instead consolidate security and networking capabilities on one unified control plane. Such network and security transformation helps address key challenges modern businesses face, including:

* Securing access for any user to any resource with Zero Trust practices
* Defending against cyber threats, including multi-channel phishing and ransomware attacks
* Protecting data in order to comply with regulations and prevent leaks
* Simplifying connectivity across offices, data centers, and cloud environments

Cloudflare One is built on Cloudflare’s connectivity cloud, ​​a unified, intelligent platform of programmable cloud-native services that enable any-to-any connectivity between all networks (enterprise and Internet), cloud environments, applications, and users. It is one of the largest global networks, with data centers spanning hundreds of cities worldwide and interconnection with over 13,000 network peers. It also has a greater presence in core Internet exchanges than many other large technology companies.

As a result, Cloudflare operates within \~50 ms of \~95% of the world’s Internet-connected population. And since all Cloudflare services are designed to run across every network location, all traffic is connected, inspected, and filtered close to the source for the best performance and consistent user experience.

This document describes a reference architecture for organizations working towards a SASE architecture, and shows how Cloudflare One enables such security and networking transformation.
